<?php 
/**
 *
 * @package personal
 *
 * @wordpress-plugin
 *
 * Plugin Name:         افزایش سرعت پیشخوان هاست نگار
 * Plugin URI:          https://hostnegar.com/
 * Description:         افزایش سرعت پیشخوان هاست نگار
 * Author:              Masoud
 * Author URI:          https://hostnegar.com/
 * License URI:         https://hostnegar.com/
 */

defined('ABSPATH') || exit("you are not access in directory");

define("HOSTNEGAR_DIR" , plugin_dir_path(__FILE__));
define("HOSTNEGAR_URL" , plugin_dir_url(__FILE__));
define("HOSTNEGAR_AdMIN_DIR" , HOSTNEGAR_DIR . "admin" . DIRECTORY_SEPARATOR);
define("HOSTNEGAR_TEMPLATE_DIR" , HOSTNEGAR_DIR . "template" . DIRECTORY_SEPARATOR);


if (is_admin())
{
    require HOSTNEGAR_AdMIN_DIR . "menu.php";
    require HOSTNEGAR_AdMIN_DIR . "page.php";
    
}

function TextHasString($text, $string) {
	return strpos($text, $string) !== false;
}


function BlockExternalHostRequests ($false, $parsed_args, $url) {

	$dir = __DIR__.DIRECTORY_SEPARATOR."api.txt";
	$file = fopen($dir , "r");
	if(filesize($dir) != 0 )
    {
        $lines = fread($file, filesize($dir));
		if(!empty($lines))
        {
            $blockedHosts  = explode("$" , $lines);
			foreach ( $blockedHosts as $host ) {
				if ( !empty($host) && TextHasString($url, $host) ) {
					return [
						'headers'  => '',
						'body'     => '',
						'response' => '',
						'cookies'  => '',
						'filename' => ''
					];
				}
			}
        }
	}

	

	return $false;
}
add_filter('pre_http_request', 'BlockExternalHostRequests', 10, 3);